* UTHERNET DRIVER
* SLOT INDEPENDENT - 31 MAY 15 - DF
* PACKETPAGE ADDRESSES
BUSSTAT EQU $0138
RECVFBYTC EQU $0050 ; RECEIVED FRAME BYTE COUNTER
RECVCONF EQU $0102 ; RECEIVER CONFIGURATION
RECVEVNT EQU $0124 ; RECEIVER EVENT
RECVCTL EQU $0104 ; RECEIVER CONTROL
TXCMDST EQU $0108 ; TRANSMIT COMMAND STATUS
TXEVENT EQU $0128 ; TRANSMITTER EVENT
LINECTL EQU $0112 ; LINE CONTROL
LINESTAT EQU $0134 ; LINE STATUS
SELFSTAT EQU $0136 ; SELF STATUS
SELFCTL EQU $0114 ; SELF CONTROL
MACADDR EQU $0158 ; MAC ADDRESS
RXMISS EQU $0130 ; MISSED FRAME COUNT (UPPER 10 BITS)
*
* SLOT I/O EQUATES
UTHID EQU $630E ; CS8900A ID BYTES
PPLO EQU $C08A ; SLOT 3 PP POINTER LO-BYTE
PPHI EQU $C08B ; PP POINTER HI-BYTE
PDLO EQU $C08C ; PP DATA LO-BYTE
PDHI EQU $C08D ; PP DATA HI-BYTE
TXCMDLO EQU $C0B4 ; TRANSMIT COMMAND LO-BYTE
TXCMDHI EQU $C0B5 ; TRANSMIT COMMAND HI-BYTE
TXLENLO EQU $C0B6 ; TRANSMISSION LENGTH LO-BYTE
TXLENHI EQU $C0B7 ; TRANSMISSION LENGTH HI-BYTE
RXTXDATLO EQU $C0B0 ; RECEIVE/TRANSMIT DATA LO-BYTE
RXTXDATHI EQU $C0B1 ; RECEIVE/TRANSMIT DATA HI-BYTE
*
ETHSLOT DFB $30 ; SLOT NUMBER AS $N0
*
*
* OUR MAC ADDRESS STORED HERE
OURMAC HEX 0080106D7630
*
* OUTGOING PACKET HEADERS STORED HERE
* THESE ARE:
* 14 BYTE ETHERNET HEAD
* 20 BYTE IP HEAD
* UP TO 32 BYTES UDP OR TCP HEAD
OUTPHEAD
 HEX FFFFFFFFFFFF ; DESTINATION MAC
 HEX 000000000000 ; SOURCE MAC
 HEX 0800   ; ETHERTYPE IP
 HEX 450000000000
 HEX 0000FF110000
 HEX 00000000   ; IP SOURCE
 HEX FFFFFFFF   ; IP DESTINATION
 DS 32   ; UDP OR TCP HEAD
*
* FIND UTHERNET CARD
*
ETHFIND
 LDX ETHSLOT
 LDA #0 ; ENSURE LO-BYTE OF PP POINTER IS 0
 STA PPLO,X
 STA PPHI,X ; SET HI-BYTE TOO
 LDA PDHI,X
 CMP #>UTHID ; COMPARE HI-BYTE OF ID
 BNE :NOUTH ; NO MATCH
 LDA PDLO,X ; GET LO-BYTE OF ID
 CMP #<UTHID ; COMPARE LO-BYTE
 BNE :NOUTH
* SAY THAT WE'VE FOUND IT, AND THEN INITIALIZE IT.
 LDY #0
:L LDA MSG2,Y
 BEQ :LDONE
 JSR COUT
 INY
 BNE :L
:LDONE JMP ETHINIT ; INITIALIZE UTHERNET CARD
:NOUTH JMP DOSWARM
*
*
*
* SEND AN ETHERNET PACKET
*
* THIS WILL ONLY SEND UP TO 255 BYTES OF DATA.
* BEFORE CALLING THIS YOU NEED TO ESTABLISH THE BUFFER ADDRESS
* AT OUTPBUF AND THE LENGTH OF DATA THEREIN AT OUTPLEN. THEN
* JUST CALL THIS AND YOUR DATA WILL BE SENT OUT, NO QUESTIONS
* ASKED.
*
ETHSEND
 LDX ETHSLOT
 LDA #$C9 ; LO-BYTE OF TRANSMIT REQUEST COMMAND
 STA TXCMDLO
 LDA #0 ; HI-BYTE
 STA TXCMDHI
 LDA OUTPLEN ; LO-BYTE OF ETHERNET FRAME LENGTH
 STA TXLENLO
 LDA OUTPLEN+1 ; HI-BYTE
 STA TXLENHI ; STORE HI-BYTE OF TRANSMISSION LENGTH
 LDA #<BUSSTAT ; LO-BYTE OF BUS STATUS REGISTER
 STA PPLO,X ; STORE LO-BYTE IN PP ADDRESS REGISTER
 LDA #>BUSSTAT ; HI-BYTE
 STA PPHI,X ; STORE HI-BYTE
 LDY #5 ; RETRIES COUNTER
:CHECK LDA PDLO,X ; LO-BYTE, DON'T CARE
 LDA PDHI,X ; HI-BYTE OF BUS STATUS
 LSR  ; SEND BIT 8 (READY TO SEND) TO CARRY FLAG
 BCS :READY ; READY TO SEND?
 LDA #48 ; NO, SO WAIT A BIT
 JSR WAIT ; WAIT, ACCUM SET TO 0
 DEY
 BPL :CHECK ; POLL AGAIN
* ERROR
:ERR
 LDY #0
:LM LDA MSG13,Y
 BEQ :NEXTERR
 JSR COUT
 INY
 BNE :LM
:NEXTERR SEC  ; ERROR
 RTS
:READY LDY #0 ; COUNTER FOR BYTES SENT
:L LDA (OUTPBUF),Y ; LOAD BYTE TO SEND
 STA RXTXDATLO ; SEND TO CS8900A TRANSMIT DATA PORT (LO)
 INY ; POINT TO NEXT DATA BYTE
 CPY OUTPLEN ; SENT ALL DATA YET?
 BEQ :DONE ; YES, SO GO TO STOPPING POINT
 LDA (OUTPBUF),Y ; LOAD NEXT BYTE TO SEND
 STA RXTXDATHI ; SEND TO TRANSMIT DATA PORT (HI)
 INY
 CPY OUTPLEN ; SENT ALL DATA BYTES YET?
 BNE :L ; NO, SO CONTINUE
:DONE
 LDY #$FF ; TIMEOUT COUNTER
:DONE2 DEY
 BEQ :TIMEOUT
* CHECK TXOK
 LDA #<TXEVENT
 STA PPLO,X
 LDA #>TXEVENT
 STA PPHI,X
 LDA PDHI,X ; TXOK IS BIT 0
 LDY PDLO,X ; DON'T CARE
 TAY
 LSR  ; TXOK IS NOW IN C
 BCS :DONEOK
 TYA ; TEST FOR ERROR
 AND #%10000110
 BEQ :DONE2 ; PROBABLY NOT DONE TRANSMITTING
* IF WE GET HERE, THERE'S BEEN A TRANSMISSION ERROR
:TIMEOUT JMP :ERR  ; TX ERROR
*
:DONEOK
 CLC  ; NO ERROR
 RTS
*
*
* SEND16
*
* THIS IS THE HIGH-LEVEL SEND ROUTINE THAT USES A 16-BIT POINTER
* TO SEND UP TO 1514 BYTES (INCLUDING 14 BYTE ETH HEADER).
* THERE ARE TWO POINTERS. ONE IS FOR OUTPHEAD WHICH HOLDS THE
* ETHERNET, IP, AND UDP HEADERS. THE SECOND IS FOR OUTPDAT
* WHICH HOLDS THE USER'S DATA IN THE UDP PACKET. THIS DESIGN IS
* INTENDED TO ELIMINATE THE NEED TO COPY A LARGE BLOCK OF DATA.
*
* THIS SUBROUTINE DOES NOT MODIFY ANY DATA. YOUR PACKET NEEDS TO
* BE COMPLETELY READY TO SEND BEFORE YOU CALL THIS!
*
* IT ALSO DOES NOT MODIFY OUTPLEN. YOU NEED TO HAVE THE USER'S
* DATA LENGTH + HEADER LENGTH (42 FOR STANDARD UDP) STORED HERE.
*
ETHSEND16
 LDX ETHSLOT
 LDA #$C9 ; LO-BYTE OF TRANSMIT REQUEST COMMAND
 STA TXCMDLO
 LDA #0 ; HI-BYTE
 STA TXCMDHI
 LDA OUTPLEN ; LO-BYTE OF ETHERNET FRAME LENGTH
 STA TXLENLO
 LDA OUTPLEN+1 ; HI-BYTE
 STA TXLENHI ; STORE HI-BYTE OF TRANSMISSION LENGTH
 LDA #<BUSSTAT ; LO-BYTE OF BUS STATUS REGISTER
 STA PPLO,X ; STORE LO-BYTE IN PP ADDRESS REGISTER
 LDA #>BUSSTAT ; HI-BYTE
 STA PPHI,X ; STORE HI-BYTE
 LDY #5 ; RETRIES COUNTER
:CHECK LDA PDLO,X ; LO-BYTE, DON'T CARE
 LDA PDHI,X ; GET HI-BYTE OF BUS STATUS
 LSR  ; SEND BIT 8 (READY TO SEND) TO CARRY FLAG
 BCS :READY ; READY TO SEND?
 LDA #48 ; NO, SO WAIT A BIT
 JSR WAIT ; WAIT, ACCUM SET TO 0
 DEY
 BPL :CHECK ; POLL AGAIN
* ERROR
:ERR
 LDY #0
:LM LDA MSG13,Y
 BEQ :NEXTERR
 JSR COUT
 INY
 BNE :LM
:NEXTERR SEC  ; ERROR
 RTS
* SEND THE HEADERS
:READY LDY #0 ; COUNTER FOR BYTES SENT
:L LDA OUTPHEAD,Y ; LOAD BYTE TO SEND
 STA RXTXDATLO ; SEND TO CS8900A TRANSMIT DATA PORT (LO)
 INY ; POINT TO NEXT DATA BYTE
 LDA OUTPHEAD,Y ; LOAD NEXT BYTE TO SEND
 STA RXTXDATHI ; SEND TO TRANSMIT DATA PORT (HI)
 INY
 CPY OUTPHLEN ; SENT ALL HEAD BYTES YET?
 BNE :L ; NO, SO CONTINUE
* NOW WE SUBTRACT OUTPHLEN FROM OUTPLEN AND ENSURE THAT
* THE RESULT IS EVEN. HAVING ZERO IS ALSO
* ACCEPTABLE, AND WE EXIT CLEANLY IN THIS CASE.
 SEC
 LDA OUTPLEN
 SBC OUTPHLEN ; HEADER LENGTH
 STA OUTPLEN
 LDA OUTPLEN+1
 SBC #0
 STA OUTPLEN+1
 LDA OUTPLEN
 LSR  ; TEST FOR ODD
 BCC :SENDBOD ; EVEN, SO SEND NOW
 CLC  ; IT'S ODD, SO ADD 1
 INC OUTPLEN
 BNE :SENDBOD
 INC OUTPLEN+1
* THIS IS WHERE WE SEND THE USER'S PACKET DATA
:SENDBOD
 LDY #0
 LDA OUTPLEN+1
 BEQ :END ; ONLY ONE PAGE OF DATA TO SEND
 TAX  ; OUTPLEN+1 IS NOW IN X
:L2 LDA (OUTPBUF),Y
 STA RXTXDATLO
 INY
 LDA (OUTPBUF),Y
 STA RXTXDATHI
 INY
 BNE :L2
 INC OUTPBUF+1
 DEX  ; NEXT BLOCK OF 256 BYTES
 BNE :L2
 LDA OUTPLEN
 BEQ :DONE ; EXACT MULTIPLE OF 256
:END
 LDA (OUTPBUF),Y
 STA RXTXDATLO
 INY
 LDA (OUTPBUF),Y
 STA RXTXDATHI
 INY
 CPY OUTPLEN ; DONE YET?
 BNE :END
:DONE
 LDX ETHSLOT
 LDY #$FF ; TIMEOUT COUNTER
:DONE2 DEY
 BEQ :TIMEOUT
 LDA #<TXEVENT ; CHECK TXOK
 STA PPLO,X
 LDA #>TXEVENT
 STA PPHI,X
 LDA PDHI,X ; TXOK IS BIT 0
 LDY PDLO,X
 TAY
 LSR
 BCS :DONEOK
 TYA ; TEST FOR ERROR
 AND #%10000110
 BEQ :DONE2 ; PROBABLY NOT DONE TRANSMITTING
* IF WE GET HERE, THERE'S BEEN A TRANSMISSION ERROR
:TIMEOUT JMP :ERR
*
:DONEOK
 CLC ; NO ERROR
 RTS
*
*
* POLL THE CS8900A FOR AN INCOMING PACKET.
* IF THERE ISN'T ONE, THEN WE RETURN WITH CARRY FLAG SET.
* BUT IF THERE IS ONE, THEN WE...
*
ETHINPOLL
 LDX ETHSLOT
 LDA #<RECVEVNT ; LOW-BYTE OF RECEIVER EVENT REGISTER
 STA PPLO,X ; STORE LOW-BYTE IN PACKETPAGE ADDR.
 LDA #>RECVEVNT ; HI-BYTE
 STA PPHI,X
 LDA PDHI,X ; GET HI-BYTE OF RECEIVE EVENT AND CHECK
 AND #%00001100 ; CHECK BITS 2 OR 3 SET IN STATUS BYTE
 BNE :GETLEN ; VALID INCOMING PACKET?
 SEC ; NO, SO SET C FLAG...
 RTS  ; ...AND EXIT
:GETLEN LDA RXTXDATHI ; GET HI-BYTE OF RECEIVE STATUS, DISCARD
 LDA RXTXDATLO ; GET LO-BYTE ... AND DISCARD IT TOO
 LDA RXTXDATHI ; HI-BYTE OF INCOMING FRAME LENGTH
 STA INPLEN+1
 LDA RXTXDATLO ; LO-BYTE
 STA INPLEN ; STORE LOW-BYTE OF FRAME LENGTH
*
*
*
* RECEIVE AN ETHERNET PACKET
*
* CALL THIS SUBROUTINE WHEN YOU HAVE ALREADY CHECKED
* THAT THE UTHERNET HAS RECEIVED A PACKET. YOU NEED TO HAVE
* STORED THE INCOMING PACKET LENGTH AT INPLEN BEFORE YOU
* CALL THIS SUBROUTINE.
* FOR NOW, ALL INCOMING PACKETS ARE STORED AT $5000
*
ETHRECV
 INC RNDL
 BNE :NEXT
 INC RNDH
:NEXT LDA INPLEN+1 ; SAVE HI-BYTE
 PHA  ; ON THE STACK FOR LATER
 LDA #0 ; LO-BYTE OF DEST. BUFFER
 STA INPBUF
 LDA #$50 ; HI-BYTE OF DEST. BUFFER
 STA INPBUF+1
 LDY #0 ; INITIALIZE OFFSET INDEX
 LDX INPLEN ; GET LO-BYTE
:READTOP LDA RXTXDATLO ; FIRST BYTE FROM UTHERNET
 STA (INPBUF),Y ; STORE IN BUFFER
 INY
 BNE :READMID
 INC INPBUF+1
:READMID DEX
 CPX #$FF ; WRAPPED BACK?
 BNE :RM2
 DEC INPLEN+1
 LDA INPLEN+1
 CMP #$FF
 BEQ :DONE
:RM2 LDA RXTXDATHI ; 2ND BYTE FROM UTHERNET
 STA (INPBUF),Y ; STORE
 INY
 BNE :READBOTTOM ; NOT WRAPPED OVER
 INC INPBUF+1 ; INCR. HI-BYTE OF DEST. ADDR.
:READBOTTOM DEX
 CPX #$FF ; LO-BYTE WRAPPED AROUND?
 BNE :READTOP ; NO, SO CONTINUE INNER LOOP
:ENDIL DEC INPLEN+1
 LDA INPLEN+1
 CMP #$FF ; WRAPPED OVER?
 BEQ :DONE ; YES, SO COPY IS DONE
 BNE :READTOP ; START INNER LOOP
:DONE PLA
 STA INPLEN+1
 LDA #0 ; RESTORE INPBUF
 STA INPBUF
 LDA #$50
 STA INPBUF+1
 CLC
 RTS
*
*
* INITIALIZE THE ETHERNET CARD
*
ETHINIT
 LDX ETHSLOT
 LDA #<SELFCTL ; LO-BYTE OF SELF CONTROL REGISTER ADDR
 STA PPLO,X ; STORE LO-BYTE IN PP ADDRESS REGISTER
 LDA #>SELFCTL ; HI-BYTE
 STA PPHI,X ; STORE HI-BYTE
 LDA #%01010101 ; LO-BYTE OF RESET CONFIG
 STA PDLO,X ; STORE LO-BYTE IN PP DATA REGISTER
 LDA #0 ; HI-BYTE IS ALL 0
 STA PDHI,X ; STORE HI-BYTE. THE CS8900A RESETS NOW
* WAIT FOR INITIALIZATION TO COMPLETE
:CHKINIT LDA #<SELFSTAT
 STA PPLO,X
 LDA #>SELFSTAT
 STA PPHI,X
 LDA PDLO,X ; WE WANT BIT 7, INITD
 LDY PDHI,X ; DON'T CARE
 TAY ; CONDITION N FLAG
 NOP
 BPL :CHKINIT ; NOT READY
*
 LDA #<RECVCTL ; LO-BYTE OF RECEIVER CONTROL REGISTER
 STA PPLO,X ; STORE LO-BYTE IN PP ADDRESS REGISTER
 LDA #>RECVCTL ; HI-BYTE
 STA PPHI,X ; STORE HI-BYTE
* RECEIVE CONTROL: ACCEPT VALID INDIVIDUAL AND BROADCAST FRAMES
 LDA #%00000101 ; LO-BYTE OF RECEIVE CONTROL
 STA PDLO,X ; STORE LO-BYTE OF CONTROL
 LDA #%00001101 ; HI-BYTE OF RECEIVE CONTROL
 STA PDHI,X ; STORE HI-BYTE OF CONTROL
ASSIGNMAC
 LDA #<MACADDR ; LO-BYTE OF MAC ADDRESS LOCATION
 STA PPLO,X ; STORE LO-BYTE IN PP POINTER
 LDA #>MACADDR
 STA PPHI,X ; STORE HI-BYTE
 LDA OURMAC ; FIRST BYTE OF MAC ADDRESS
 STA PDLO,X ; STORE LO-BYTE IN DATA REGISTER
 LDA OURMAC+1 ; SECOND BYTE
 STA PDHI,X ; STORE HI-BYTE
 LDA #MACADDR+2 ; INCR. MAC ADDRESS LOCATION
 STA PPLO,X
 LDA OURMAC+2 ; 3RD BYTE OF MAC ADDR
 STA PDLO,X
 LDA OURMAC+3 ; 4TH BYTE
 STA PDHI,X
 LDA #MACADDR+4
 STA PPLO,X ; UPDATE PP POINTER FOR LAST TWO BYTES
 LDA OURMAC+4 ; 5TH BYTE
 STA PDLO,X
 LDA OURMAC+5 ; 6TH AND FINAL BYTE OF MAC ADDR
 STA PDHI,X ; MAC ADDRESS IS ASSIGNED
* COPY OURMAC INTO OUTPHEAD
 LDX #5 ; OFFSET FOR OURMAC
 LDY #11 ; OFFSET FOR OUTPHEAD
:OML LDA OURMAC,X
 STA OUTPHEAD,Y
 DEY
 DEX
 BPL :OML
ALLOWTX   ; ALLOW CS8900A TO SEND AND RECV
 LDX ETHSLOT
 LDA #<LINECTL ; LO-BYTE OF LINE CONTROL ADDRESS
 STA PPLO,X ; STORE LO-BYTE IN PP POINTER
 LDA #>LINECTL ; HI-BYTE
 STA PPHI,X
 LDA #$D3 ; LO-BYTE OF LINE CTL TURNS ON SEND AND RECV
 STA PDLO,X ; STORE LO-BYTE TO PP DATA
 LDA #0  ; HI-BYTE IS ZERO
 STA PDHI,X ; STORE HI-BYTE
 CLC ; NO ERRORS!
 RTS ; DONE WITH INITIALIZATION
